/*
 * Decompiled with CFR 0.152.
 */
package org.openntf.xsp.jsonapi.jaxrs;

import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.ContextResolver;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Providers;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.weld.proxy.WeldClientProxy;
import org.openntf.xsp.jakartaee.servlet.ServletUtil;
import org.openntf.xsp.jsonapi.JSONBindUtil;

@Produces(value={"application/json", "application/*+json", "text/json", "*/*"})
@Consumes(value={"application/json", "application/*+json", "text/json", "*/*"})
public class JsonBindingProvider
implements MessageBodyWriter<Object>,
MessageBodyReader<Object> {
    private static final Logger log = Logger.getLogger(JsonBindingProvider.class.getPackage().getName());
    public static final String PROP_STREAM = "rest.jsonb.stream";
    @Context
    private Providers providers;
    @Context
    private Application application;
    private static final String JSON = "json";
    private static final String PLUS_JSON = "+json";

    protected Jsonb getJsonb(Class<?> type) {
        ContextResolver resolver = this.providers.getContextResolver(Jsonb.class, MediaType.WILDCARD_TYPE);
        if (resolver != null) {
            return (Jsonb)resolver.getContext(Jsonb.class);
        }
        return JsonbBuilder.create();
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return JsonBindingProvider.isSupportedMediaType(mediaType);
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        try {
            Jsonb jsonb = this.getJsonb(type);
            return JSONBindUtil.fromJson((InputStream)entityStream, (Jsonb)jsonb, (Type)genericType);
        }
        catch (Exception e) {
            if (log.isLoggable(Level.SEVERE)) {
                log.log(Level.SEVERE, "Encountered exception reading JSON input", e);
            }
            throw e;
        }
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return JsonBindingProvider.isSupportedMediaType(mediaType);
    }

    public long getSize(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        try {
            Object obj = t;
            if (obj instanceof WeldClientProxy) {
                WeldClientProxy.Metadata meta = ((WeldClientProxy)obj).getMetadata();
                obj = meta.getContextualInstance();
            }
            Jsonb jsonb = this.getJsonb(type);
            boolean stream = false;
            Application app = this.application;
            if (app != null) {
                Object streamProp = app.getProperties().get(PROP_STREAM);
                boolean bl = stream = !"false".equals(streamProp);
            }
            if (stream) {
                JSONBindUtil.toJson((Object)obj, (Jsonb)jsonb, (OutputStream)entityStream);
            } else {
                String json = JSONBindUtil.toJson((Object)obj, (Jsonb)jsonb);
                entityStream.write(json.getBytes(StandardCharsets.UTF_8));
            }
            entityStream.flush();
        }
        catch (Exception e) {
            if (ServletUtil.isClosedConnection((Throwable)e)) {
                return;
            }
            if (log.isLoggable(Level.SEVERE)) {
                log.log(Level.SEVERE, "Encountered exception writing JSON output", e);
            }
            throw e;
        }
    }

    public static boolean isSupportedMediaType(MediaType mediaType) {
        return mediaType.getSubtype().equals(JSON) || mediaType.getSubtype().endsWith(PLUS_JSON);
    }
}

