/*
 * Decompiled with CFR 0.152.
 */
package org.openntf.xsp.microprofile.openapi;

import com.ibm.commons.util.PathUtil;
import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.models.servers.ServerImpl;
import io.smallrye.openapi.runtime.OpenApiProcessor;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Context;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.info.Info;
import org.eclipse.microprofile.openapi.models.servers.Server;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexView;
import org.openntf.xsp.jakarta.rest.nsf.RestServletFactory;
import org.openntf.xsp.jakartaee.DelegatingClassLoader;
import org.openntf.xsp.jakartaee.module.ComponentModuleLocator;
import org.openntf.xsp.jakartaee.util.ModuleUtil;

public abstract class AbstractOpenAPIResource {
    @Context
    protected Configuration jaxrsConfig;
    @Context
    protected Application application;
    @Context
    protected HttpServletRequest req;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OpenAPI buildOpenAPI() throws IOException {
        HashSet classes = new HashSet();
        classes.addAll(this.application.getClasses());
        classes.add(this.application.getClass());
        Optional module = ComponentModuleLocator.getDefault();
        module.map(ComponentModuleLocator::getActiveModule).map(ModuleUtil::getClasses).ifPresent(moduleClasses -> moduleClasses.forEach(classes::add));
        Index index = Index.of(classes);
        Config mpConfig = (Config)CDI.current().select(Config.class, new Annotation[0]).get();
        OpenApiConfig config = OpenApiConfig.fromConfig((Config)mpConfig);
        DelegatingClassLoader cl = new DelegatingClassLoader(new ClassLoader[]{OpenApiProcessor.class.getClassLoader(), Thread.currentThread().getContextClassLoader()});
        Class<OpenApiProcessor> clazz = OpenApiProcessor.class;
        synchronized (OpenApiProcessor.class) {
            OpenAPI openapi = OpenApiProcessor.bootstrap((OpenApiConfig)config, (IndexView)index, (ClassLoader)cl);
            // ** MonitorExit[var8_7] (shouldn't be in output)
            Info info = openapi.getInfo();
            String existingTitle = config.getInfoTitle();
            if (existingTitle == null || existingTitle.isEmpty()) {
                info.setTitle((String)module.map(ComponentModuleLocator::getTitle).orElse(null));
            } else {
                info.setTitle(existingTitle);
            }
            String existingVersion = config.getInfoVersion();
            if (existingVersion == null || existingVersion.isEmpty()) {
                String version = module.flatMap(ComponentModuleLocator::getVersion).orElse(null);
                info.setVersion(version);
            } else {
                info.setVersion(existingVersion);
            }
            List servers = config.servers();
            if (servers == null || servers.isEmpty()) {
                ServerImpl server = new ServerImpl();
                URI uri = URI.create(this.req.getRequestURL().toString());
                String jaxrsRoot = module.map(ComponentModuleLocator::getActiveModule).map(RestServletFactory::getServletPath).orElse("");
                String uriString = (uri = uri.resolve(PathUtil.concat((String)this.req.getContextPath(), (String)jaxrsRoot, (char)'/'))).toString();
                if (uriString.endsWith("/")) {
                    uriString = uriString.substring(0, uriString.length() - 1);
                }
                server.setUrl(uriString);
                openapi.addServer((Server)server);
            }
            return openapi;
        }
    }
}

