/*
 * Decompiled with CFR 0.152.
 */
package org.openntf.xsp.microprofile.openapi;

import io.smallrye.openapi.runtime.io.Format;
import io.smallrye.openapi.runtime.io.OpenApiSerializer;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.openntf.xsp.jakartaee.metrics.MetricsIgnore;
import org.openntf.xsp.microprofile.openapi.AbstractOpenAPIResource;

@Path(value="openapi")
@MetricsIgnore
public class OpenAPIResource
extends AbstractOpenAPIResource {
    @GET
    @Operation(hidden=true)
    public Response get(@Context HttpHeaders headers) throws IOException {
        OpenAPI openapi = this.buildOpenAPI();
        boolean hasJson = headers.getAcceptableMediaTypes().stream().anyMatch(type -> !type.isWildcardType() && !type.isWildcardSubtype() && type.isCompatible(MediaType.APPLICATION_JSON_TYPE));
        if (hasJson) {
            return Response.ok().type(MediaType.APPLICATION_JSON_TYPE).entity((Object)OpenApiSerializer.serialize((OpenAPI)openapi, (Format)Format.JSON)).build();
        }
        return Response.ok().type("text/plain").entity((Object)OpenApiSerializer.serialize((OpenAPI)openapi, (Format)Format.YAML)).build();
    }
}

